/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027;

import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.createsubscription.CreateSubscriptionInput;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.deletesubscription.DeleteSubscriptionInput;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.deletesubscription.DeleteSubscriptionOutput;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.establishsubscription.EstablishSubscriptionInput;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.establishsubscription.EstablishSubscriptionOutput;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.modifysubscription.ModifySubscriptionInput;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.modifysubscription.ModifySubscriptionOutput;
import org.onosproject.yang.model.RpcInput;
import org.onosproject.yang.model.RpcOutput;
import org.onosproject.yang.model.RpcService;

/**
 * Abstraction of an entity which represents the functionality of yrtIetfEventNotifications.
 */
public interface YrtIetfEventNotificationsService extends RpcService {
    /**
     * Service interface of establishSubscription.
     *
     * @param inputVar input of service interface establishSubscription
     * @return rpcOutput output of service interface establishSubscription
     */
    RpcOutput establishSubscription(RpcInput inputVar);

    /**
     * Service interface of createSubscription.
     *
     * @param inputVar input of service interface createSubscription
     * @return rpcOutput output of service interface createSubscription
     */
    RpcOutput createSubscription(RpcInput inputVar);

    /**
     * Service interface of modifySubscription.
     *
     * @param inputVar input of service interface modifySubscription
     * @return rpcOutput output of service interface modifySubscription
     */
    RpcOutput modifySubscription(RpcInput inputVar);

    /**
     * Service interface of deleteSubscription.
     *
     * @param inputVar input of service interface deleteSubscription
     * @return rpcOutput output of service interface deleteSubscription
     */
    RpcOutput deleteSubscription(RpcInput inputVar);

}
