/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027;

import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Filters;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Streams;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionConfig;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Subscriptions;

/**
 * Abstraction of an entity which represents the functionality of yrtIetfEventNotifications.
 */
public interface YrtIetfEventNotifications {

    /**
     * Returns the attribute streams.
     *
     * @return streams value of streams
     */
    Streams streams();

    /**
     * Returns the attribute filters.
     *
     * @return filters value of filters
     */
    Filters filters();

    /**
     * Returns the attribute subscriptionConfig.
     *
     * @return subscriptionConfig value of subscriptionConfig
     */
    SubscriptionConfig subscriptionConfig();

    /**
     * Returns the attribute subscriptions.
     *
     * @return subscriptions value of subscriptions
     */
    Subscriptions subscriptions();

    /**
     * Sets the attribute streams.
     *
     * @param streams value of streams
     */
    void streams(Streams streams);

    /**
     * Sets the attribute filters.
     *
     * @param filters value of filters
     */
    void filters(Filters filters);

    /**
     * Sets the attribute subscriptionConfig.
     *
     * @param subscriptionConfig value of subscriptionConfig
     */
    void subscriptionConfig(SubscriptionConfig subscriptionConfig);

    /**
     * Sets the attribute subscriptions.
     *
     * @param subscriptions value of subscriptions
     */
    void subscriptions(Subscriptions subscriptions);

}