/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.choice1.case1b.choice1b;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.choice1.case1b.Choice1b;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of case1Bii.
 */
public interface Case1Bii extends Choice1b, Augmentable  {

    /**
     * Identify the leaf of Case1Bii.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf1Biia.
         */
        LEAF1BIIA(1),
        /**
         * Represents leaf1Biib.
         */
        LEAF1BIIB(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf1Biia.
     *
     * @return leaf1Biia value of leaf1Biia
     */
    String leaf1Biia();

    /**
     * Returns the attribute leaf1Biib.
     *
     * @return leaf1Biib value of leaf1Biib
     */
    String leaf1Biib();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute leaf1Biia.
     *
     * @param leaf1Biia value of leaf1Biia
     */
    void leaf1Biia(String leaf1Biia);

    /**
     * Sets the attribute leaf1Biib.
     *
     * @param leaf1Biib value of leaf1Biib
     */
    void leaf1Biib(String leaf1Biib);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}