/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.choice1;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.Choice1;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.choice1.case1b.Choice1b;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of case1b.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCase1b extends InnerModelObject implements Case1b {
    protected Choice1b choice1b;

    @Override
    public Choice1b choice1b() {
        return choice1b;
    }

    @Override
    public void choice1b(Choice1b choice1b) {
        this.choice1b = choice1b;
    }

    @Override
    public int hashCode() {
        return Objects.hash(choice1b);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCase1b) {
            DefaultCase1b other = (DefaultCase1b) obj;
            return
                Objects.deepEquals(choice1b, other.choice1b);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("choice1b=" + choice1b)
            .toString();
    }


    /**
     * Creates an instance of defaultCase1b.
     */
    public DefaultCase1b() {
    }

}