/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2;

import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.Choice2;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2.case2b.Choice3b;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of case2b.
 */
public interface Case2b extends Choice2, Augmentable  {

    /**
     * Returns the attribute choice3b.
     *
     * @return choice3b value of choice3b
     */
    Choice3b choice3b();

    /**
     * Sets the attribute choice3b.
     *
     * @param choice3b value of choice3b
     */
    void choice3b(Choice3b choice3b);

}