/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yangautoprefixlist.rev20160624;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yangautoprefixlist.rev20160624.list2.L2;

/**
 * Abstraction of an entity which represents the functionality of list2.
 */
public interface List2 {

    /**
     * Identify the leaf of List2.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf2.
         */
        LEAF2(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf2.
     *
     * @return leaf2 list of leaf2
     */
    List<String> leaf2();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute l2.
     *
     * @return l2 list of l2
     */
    List<L2> l2();

    /**
     * Sets the attribute leaf2.
     *
     * @param leaf2 list of leaf2
     */
    void leaf2(List<String> leaf2);

    /**
     * Sets the attribute l2.
     *
     * @param l2 list of l2
     */
    void l2(List<L2> l2);

    /**
     * Adds to the list of leaf2.
     *
     * @param addTo value of leaf2
     */
    void addToLeaf2(String addTo);

    /**
     * Adds to the list of l2.
     *
     * @param addTo value of l2
     */
    void addToL2(L2 addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}