/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of lfunion2Union.
 */
public final class Lfunion2Union {
    private BigDecimal decimal64;
    private String string;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of lfunion2Union.
     */
    private Lfunion2Union() {
    }

    /**
     * Creates an instance of decimal64.
     *
     * @param decimal64 value of decimal64
     */
    public Lfunion2Union(BigDecimal decimal64) {
        setValue.set(0);
        this.decimal64 = decimal64;
    }

    /**
     * Creates an instance of string.
     *
     * @param string value of string
     */
    public Lfunion2Union(String string) {
        setValue.set(1);
        this.string = string;
    }

    /**
     * Returns the object of lfunion2Union for type decimal64.
     *
     * @param value value of lfunion2Union for type decimal64
     * @return lfunion2Union for type decimal64
     */
    public static Lfunion2Union of(BigDecimal value) {
        return new Lfunion2Union(value);
    }

    /**
     * Returns the object of lfunion2Union for type string.
     *
     * @param value value of lfunion2Union for type string
     * @return lfunion2Union for type string
     */
    public static Lfunion2Union of(String value) {
        return new Lfunion2Union(value);
    }

    /**
     * Returns the attribute decimal64.
     *
     * @return decimal64 value of decimal64
     */
    public BigDecimal decimal64() {
        return decimal64;
    }
    /**
     * Returns the attribute string.
     *
     * @return string value of string
     */
    public String string() {
        return string;
    }
    /**
     * Sets the attribute decimal64.
     *
     * @param decimal64 value of decimal64
     */
    public void decimal64(BigDecimal decimal64) {
        this.decimal64 = decimal64;
    }
    /**
     * Sets the attribute string.
     *
     * @param string value of string
     */
    public void string(String string) {
        this.string = string;
    }

    @Override
    public int hashCode() {
        return Objects.hash(decimal64, string);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lfunion2Union) {
            Lfunion2Union other = (Lfunion2Union) obj;
            return
                Objects.deepEquals(decimal64, other.decimal64) &&
                Objects.deepEquals(string, other.string);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return decimal64.toString();
        }
        if (setValue.get(1)) {
            return string;
        }
        return null;
    }
    /**
     * Returns the object of lfunion2Union fromString input String lfunion2Union.
     *
     * @param valInString value of input String
     * @return lfunion2Union
     */
    public static Lfunion2Union fromString(String valInString) {
        try {
            BigDecimal tmpVal = new BigDecimal(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            String tmpVal = (valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
