/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfenum1Enum;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfenum2Enum;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.LfenumEnum;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion10Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion11Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion14Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion1Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion2Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion4Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion5Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion8Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion9Union;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of cont1.
 */
public interface Cont1 extends Augmentable  {

    /**
     * Identify the leaf of Cont1.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents lfnint8Min.
         */
        LFNINT8MIN(1),
        /**
         * Represents lfnint8Max.
         */
        LFNINT8MAX(2),
        /**
         * Represents lfnint16Min.
         */
        LFNINT16MIN(3),
        /**
         * Represents lfnint16Max.
         */
        LFNINT16MAX(4),
        /**
         * Represents lfnint32Min.
         */
        LFNINT32MIN(5),
        /**
         * Represents lfnint32Max.
         */
        LFNINT32MAX(6),
        /**
         * Represents lfnint64Min.
         */
        LFNINT64MIN(7),
        /**
         * Represents lfnint64Max.
         */
        LFNINT64MAX(8),
        /**
         * Represents lfnuint8Max.
         */
        LFNUINT8MAX(9),
        /**
         * Represents lfnuint16Max.
         */
        LFNUINT16MAX(10),
        /**
         * Represents lfnuint32Max.
         */
        LFNUINT32MAX(11),
        /**
         * Represents lfuint64Max.
         */
        LFUINT64MAX(12),
        /**
         * Represents lfstr.
         */
        LFSTR(13),
        /**
         * Represents lfstr1.
         */
        LFSTR1(14),
        /**
         * Represents lfbool1.
         */
        LFBOOL1(15),
        /**
         * Represents lfbool2.
         */
        LFBOOL2(16),
        /**
         * Represents lfbool3.
         */
        LFBOOL3(17),
        /**
         * Represents lfdecimal1.
         */
        LFDECIMAL1(18),
        /**
         * Represents lfdecimal2.
         */
        LFDECIMAL2(19),
        /**
         * Represents lfdecimal3.
         */
        LFDECIMAL3(20),
        /**
         * Represents lfdecimal4.
         */
        LFDECIMAL4(21),
        /**
         * Represents lfdecimal6.
         */
        LFDECIMAL6(22),
        /**
         * Represents lfenum.
         */
        LFENUM(23),
        /**
         * Represents lfbits.
         */
        LFBITS(24),
        /**
         * Represents lfbinary.
         */
        LFBINARY(25),
        /**
         * Represents lfref1.
         */
        LFREF1(26),
        /**
         * Represents lfref2.
         */
        LFREF2(27),
        /**
         * Represents lfempty.
         */
        LFEMPTY(28),
        /**
         * Represents lfunion1.
         */
        LFUNION1(29),
        /**
         * Represents lfunion2.
         */
        LFUNION2(30),
        /**
         * Represents lfunion4.
         */
        LFUNION4(31),
        /**
         * Represents lfunion5.
         */
        LFUNION5(32),
        /**
         * Represents lfunion7.
         */
        LFUNION7(33),
        /**
         * Represents lfunion8.
         */
        LFUNION8(34),
        /**
         * Represents lfunion9.
         */
        LFUNION9(35),
        /**
         * Represents lfunion10.
         */
        LFUNION10(36),
        /**
         * Represents lfunion11.
         */
        LFUNION11(37),
        /**
         * Represents lfunion12.
         */
        LFUNION12(38),
        /**
         * Represents lfunion13.
         */
        LFUNION13(39),
        /**
         * Represents lfunion14.
         */
        LFUNION14(40),
        /**
         * Represents identityref1.
         */
        IDENTITYREF1(41),
        /**
         * Represents lfenum1.
         */
        LFENUM1(42),
        /**
         * Represents lfenum2.
         */
        LFENUM2(43);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute lfnint8Min.
     *
     * @return lfnint8Min list of lfnint8Min
     */
    List<Byte> lfnint8Min();

    /**
     * Returns the attribute lfnint8Max.
     *
     * @return lfnint8Max list of lfnint8Max
     */
    List<Byte> lfnint8Max();

    /**
     * Returns the attribute lfnint16Min.
     *
     * @return lfnint16Min list of lfnint16Min
     */
    List<Short> lfnint16Min();

    /**
     * Returns the attribute lfnint16Max.
     *
     * @return lfnint16Max list of lfnint16Max
     */
    List<Short> lfnint16Max();

    /**
     * Returns the attribute lfnint32Min.
     *
     * @return lfnint32Min list of lfnint32Min
     */
    List<Integer> lfnint32Min();

    /**
     * Returns the attribute lfnint32Max.
     *
     * @return lfnint32Max list of lfnint32Max
     */
    List<Integer> lfnint32Max();

    /**
     * Returns the attribute lfnint64Min.
     *
     * @return lfnint64Min list of lfnint64Min
     */
    List<Long> lfnint64Min();

    /**
     * Returns the attribute lfnint64Max.
     *
     * @return lfnint64Max list of lfnint64Max
     */
    List<Long> lfnint64Max();

    /**
     * Returns the attribute lfnuint8Max.
     *
     * @return lfnuint8Max list of lfnuint8Max
     */
    List<Short> lfnuint8Max();

    /**
     * Returns the attribute lfnuint16Max.
     *
     * @return lfnuint16Max list of lfnuint16Max
     */
    List<Integer> lfnuint16Max();

    /**
     * Returns the attribute lfnuint32Max.
     *
     * @return lfnuint32Max list of lfnuint32Max
     */
    List<Long> lfnuint32Max();

    /**
     * Returns the attribute lfuint64Max.
     *
     * @return lfuint64Max list of lfuint64Max
     */
    List<BigInteger> lfuint64Max();

    /**
     * Returns the attribute lfstr.
     *
     * @return lfstr list of lfstr
     */
    List<String> lfstr();

    /**
     * Returns the attribute lfstr1.
     *
     * @return lfstr1 list of lfstr1
     */
    List<String> lfstr1();

    /**
     * Returns the attribute lfbool1.
     *
     * @return lfbool1 list of lfbool1
     */
    List<Boolean> lfbool1();

    /**
     * Returns the attribute lfbool2.
     *
     * @return lfbool2 list of lfbool2
     */
    List<Boolean> lfbool2();

    /**
     * Returns the attribute lfbool3.
     *
     * @return lfbool3 list of lfbool3
     */
    List<Boolean> lfbool3();

    /**
     * Returns the attribute lfdecimal1.
     *
     * @return lfdecimal1 list of lfdecimal1
     */
    List<BigDecimal> lfdecimal1();

    /**
     * Returns the attribute lfdecimal2.
     *
     * @return lfdecimal2 list of lfdecimal2
     */
    List<BigDecimal> lfdecimal2();

    /**
     * Returns the attribute lfdecimal3.
     *
     * @return lfdecimal3 list of lfdecimal3
     */
    List<BigDecimal> lfdecimal3();

    /**
     * Returns the attribute lfdecimal4.
     *
     * @return lfdecimal4 list of lfdecimal4
     */
    List<BigDecimal> lfdecimal4();

    /**
     * Returns the attribute lfdecimal6.
     *
     * @return lfdecimal6 list of lfdecimal6
     */
    List<BigDecimal> lfdecimal6();

    /**
     * Returns the attribute lfenum.
     *
     * @return lfenum list of lfenum
     */
    List<LfenumEnum> lfenum();

    /**
     * Returns the attribute lfbits.
     *
     * @return lfbits list of lfbits
     */
    List<BitSet> lfbits();

    /**
     * Returns the attribute lfbinary.
     *
     * @return lfbinary list of lfbinary
     */
    List<byte[]> lfbinary();

    /**
     * Returns the attribute lfref1.
     *
     * @return lfref1 list of lfref1
     */
    List<String> lfref1();

    /**
     * Returns the attribute lfref2.
     *
     * @return lfref2 list of lfref2
     */
    List<Byte> lfref2();

    /**
     * Returns the attribute lfempty.
     *
     * @return lfempty list of lfempty
     */
    List<Boolean> lfempty();

    /**
     * Returns the attribute lfunion1.
     *
     * @return lfunion1 list of lfunion1
     */
    List<Lfunion1Union> lfunion1();

    /**
     * Returns the attribute lfunion2.
     *
     * @return lfunion2 list of lfunion2
     */
    List<Lfunion2Union> lfunion2();

    /**
     * Returns the attribute lfunion4.
     *
     * @return lfunion4 list of lfunion4
     */
    List<Lfunion4Union> lfunion4();

    /**
     * Returns the attribute lfunion5.
     *
     * @return lfunion5 list of lfunion5
     */
    List<Lfunion5Union> lfunion5();

    /**
     * Returns the attribute lfunion7.
     *
     * @return lfunion7 list of lfunion7
     */
    List<Tpdfun3> lfunion7();

    /**
     * Returns the attribute lfunion8.
     *
     * @return lfunion8 list of lfunion8
     */
    List<Lfunion8Union> lfunion8();

    /**
     * Returns the attribute lfunion9.
     *
     * @return lfunion9 list of lfunion9
     */
    List<Lfunion9Union> lfunion9();

    /**
     * Returns the attribute lfunion10.
     *
     * @return lfunion10 list of lfunion10
     */
    List<Lfunion10Union> lfunion10();

    /**
     * Returns the attribute lfunion11.
     *
     * @return lfunion11 list of lfunion11
     */
    List<Lfunion11Union> lfunion11();

    /**
     * Returns the attribute lfunion12.
     *
     * @return lfunion12 list of lfunion12
     */
    List<Tpdfun2> lfunion12();

    /**
     * Returns the attribute lfunion13.
     *
     * @return lfunion13 list of lfunion13
     */
    List<Tpdfbit> lfunion13();

    /**
     * Returns the attribute lfunion14.
     *
     * @return lfunion14 list of lfunion14
     */
    List<Lfunion14Union> lfunion14();

    /**
     * Returns the attribute identityref1.
     *
     * @return identityref1 list of identityref1
     */
    List<Class<? extends Iden>> identityref1();

    /**
     * Returns the attribute lfenum1.
     *
     * @return lfenum1 list of lfenum1
     */
    List<Lfenum1Enum> lfenum1();

    /**
     * Returns the attribute lfenum2.
     *
     * @return lfenum2 list of lfenum2
     */
    List<Lfenum2Enum> lfenum2();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute lfnint8Min.
     *
     * @param lfnint8Min list of lfnint8Min
     */
    void lfnint8Min(List<Byte> lfnint8Min);

    /**
     * Sets the attribute lfnint8Max.
     *
     * @param lfnint8Max list of lfnint8Max
     */
    void lfnint8Max(List<Byte> lfnint8Max);

    /**
     * Sets the attribute lfnint16Min.
     *
     * @param lfnint16Min list of lfnint16Min
     */
    void lfnint16Min(List<Short> lfnint16Min);

    /**
     * Sets the attribute lfnint16Max.
     *
     * @param lfnint16Max list of lfnint16Max
     */
    void lfnint16Max(List<Short> lfnint16Max);

    /**
     * Sets the attribute lfnint32Min.
     *
     * @param lfnint32Min list of lfnint32Min
     */
    void lfnint32Min(List<Integer> lfnint32Min);

    /**
     * Sets the attribute lfnint32Max.
     *
     * @param lfnint32Max list of lfnint32Max
     */
    void lfnint32Max(List<Integer> lfnint32Max);

    /**
     * Sets the attribute lfnint64Min.
     *
     * @param lfnint64Min list of lfnint64Min
     */
    void lfnint64Min(List<Long> lfnint64Min);

    /**
     * Sets the attribute lfnint64Max.
     *
     * @param lfnint64Max list of lfnint64Max
     */
    void lfnint64Max(List<Long> lfnint64Max);

    /**
     * Sets the attribute lfnuint8Max.
     *
     * @param lfnuint8Max list of lfnuint8Max
     */
    void lfnuint8Max(List<Short> lfnuint8Max);

    /**
     * Sets the attribute lfnuint16Max.
     *
     * @param lfnuint16Max list of lfnuint16Max
     */
    void lfnuint16Max(List<Integer> lfnuint16Max);

    /**
     * Sets the attribute lfnuint32Max.
     *
     * @param lfnuint32Max list of lfnuint32Max
     */
    void lfnuint32Max(List<Long> lfnuint32Max);

    /**
     * Sets the attribute lfuint64Max.
     *
     * @param lfuint64Max list of lfuint64Max
     */
    void lfuint64Max(List<BigInteger> lfuint64Max);

    /**
     * Sets the attribute lfstr.
     *
     * @param lfstr list of lfstr
     */
    void lfstr(List<String> lfstr);

    /**
     * Sets the attribute lfstr1.
     *
     * @param lfstr1 list of lfstr1
     */
    void lfstr1(List<String> lfstr1);

    /**
     * Sets the attribute lfbool1.
     *
     * @param lfbool1 list of lfbool1
     */
    void lfbool1(List<Boolean> lfbool1);

    /**
     * Sets the attribute lfbool2.
     *
     * @param lfbool2 list of lfbool2
     */
    void lfbool2(List<Boolean> lfbool2);

    /**
     * Sets the attribute lfbool3.
     *
     * @param lfbool3 list of lfbool3
     */
    void lfbool3(List<Boolean> lfbool3);

    /**
     * Sets the attribute lfdecimal1.
     *
     * @param lfdecimal1 list of lfdecimal1
     */
    void lfdecimal1(List<BigDecimal> lfdecimal1);

    /**
     * Sets the attribute lfdecimal2.
     *
     * @param lfdecimal2 list of lfdecimal2
     */
    void lfdecimal2(List<BigDecimal> lfdecimal2);

    /**
     * Sets the attribute lfdecimal3.
     *
     * @param lfdecimal3 list of lfdecimal3
     */
    void lfdecimal3(List<BigDecimal> lfdecimal3);

    /**
     * Sets the attribute lfdecimal4.
     *
     * @param lfdecimal4 list of lfdecimal4
     */
    void lfdecimal4(List<BigDecimal> lfdecimal4);

    /**
     * Sets the attribute lfdecimal6.
     *
     * @param lfdecimal6 list of lfdecimal6
     */
    void lfdecimal6(List<BigDecimal> lfdecimal6);

    /**
     * Sets the attribute lfenum.
     *
     * @param lfenum list of lfenum
     */
    void lfenum(List<LfenumEnum> lfenum);

    /**
     * Sets the attribute lfbits.
     *
     * @param lfbits list of lfbits
     */
    void lfbits(List<BitSet> lfbits);

    /**
     * Sets the attribute lfbinary.
     *
     * @param lfbinary list of lfbinary
     */
    void lfbinary(List<byte[]> lfbinary);

    /**
     * Sets the attribute lfref1.
     *
     * @param lfref1 list of lfref1
     */
    void lfref1(List<String> lfref1);

    /**
     * Sets the attribute lfref2.
     *
     * @param lfref2 list of lfref2
     */
    void lfref2(List<Byte> lfref2);

    /**
     * Sets the attribute lfempty.
     *
     * @param lfempty list of lfempty
     */
    void lfempty(List<Boolean> lfempty);

    /**
     * Sets the attribute lfunion1.
     *
     * @param lfunion1 list of lfunion1
     */
    void lfunion1(List<Lfunion1Union> lfunion1);

    /**
     * Sets the attribute lfunion2.
     *
     * @param lfunion2 list of lfunion2
     */
    void lfunion2(List<Lfunion2Union> lfunion2);

    /**
     * Sets the attribute lfunion4.
     *
     * @param lfunion4 list of lfunion4
     */
    void lfunion4(List<Lfunion4Union> lfunion4);

    /**
     * Sets the attribute lfunion5.
     *
     * @param lfunion5 list of lfunion5
     */
    void lfunion5(List<Lfunion5Union> lfunion5);

    /**
     * Sets the attribute lfunion7.
     *
     * @param lfunion7 list of lfunion7
     */
    void lfunion7(List<Tpdfun3> lfunion7);

    /**
     * Sets the attribute lfunion8.
     *
     * @param lfunion8 list of lfunion8
     */
    void lfunion8(List<Lfunion8Union> lfunion8);

    /**
     * Sets the attribute lfunion9.
     *
     * @param lfunion9 list of lfunion9
     */
    void lfunion9(List<Lfunion9Union> lfunion9);

    /**
     * Sets the attribute lfunion10.
     *
     * @param lfunion10 list of lfunion10
     */
    void lfunion10(List<Lfunion10Union> lfunion10);

    /**
     * Sets the attribute lfunion11.
     *
     * @param lfunion11 list of lfunion11
     */
    void lfunion11(List<Lfunion11Union> lfunion11);

    /**
     * Sets the attribute lfunion12.
     *
     * @param lfunion12 list of lfunion12
     */
    void lfunion12(List<Tpdfun2> lfunion12);

    /**
     * Sets the attribute lfunion13.
     *
     * @param lfunion13 list of lfunion13
     */
    void lfunion13(List<Tpdfbit> lfunion13);

    /**
     * Sets the attribute lfunion14.
     *
     * @param lfunion14 list of lfunion14
     */
    void lfunion14(List<Lfunion14Union> lfunion14);

    /**
     * Sets the attribute identityref1.
     *
     * @param identityref1 list of identityref1
     */
    void identityref1(List<Class<? extends Iden>> identityref1);

    /**
     * Sets the attribute lfenum1.
     *
     * @param lfenum1 list of lfenum1
     */
    void lfenum1(List<Lfenum1Enum> lfenum1);

    /**
     * Sets the attribute lfenum2.
     *
     * @param lfenum2 list of lfenum2
     */
    void lfenum2(List<Lfenum2Enum> lfenum2);

    /**
     * Adds to the list of lfnint8Min.
     *
     * @param addTo value of lfnint8Min
     */
    void addToLfnint8Min(Byte addTo);

    /**
     * Adds to the list of lfnint8Max.
     *
     * @param addTo value of lfnint8Max
     */
    void addToLfnint8Max(Byte addTo);

    /**
     * Adds to the list of lfnint16Min.
     *
     * @param addTo value of lfnint16Min
     */
    void addToLfnint16Min(Short addTo);

    /**
     * Adds to the list of lfnint16Max.
     *
     * @param addTo value of lfnint16Max
     */
    void addToLfnint16Max(Short addTo);

    /**
     * Adds to the list of lfnint32Min.
     *
     * @param addTo value of lfnint32Min
     */
    void addToLfnint32Min(Integer addTo);

    /**
     * Adds to the list of lfnint32Max.
     *
     * @param addTo value of lfnint32Max
     */
    void addToLfnint32Max(Integer addTo);

    /**
     * Adds to the list of lfnint64Min.
     *
     * @param addTo value of lfnint64Min
     */
    void addToLfnint64Min(Long addTo);

    /**
     * Adds to the list of lfnint64Max.
     *
     * @param addTo value of lfnint64Max
     */
    void addToLfnint64Max(Long addTo);

    /**
     * Adds to the list of lfnuint8Max.
     *
     * @param addTo value of lfnuint8Max
     */
    void addToLfnuint8Max(Short addTo);

    /**
     * Adds to the list of lfnuint16Max.
     *
     * @param addTo value of lfnuint16Max
     */
    void addToLfnuint16Max(Integer addTo);

    /**
     * Adds to the list of lfnuint32Max.
     *
     * @param addTo value of lfnuint32Max
     */
    void addToLfnuint32Max(Long addTo);

    /**
     * Adds to the list of lfuint64Max.
     *
     * @param addTo value of lfuint64Max
     */
    void addToLfuint64Max(BigInteger addTo);

    /**
     * Adds to the list of lfstr.
     *
     * @param addTo value of lfstr
     */
    void addToLfstr(String addTo);

    /**
     * Adds to the list of lfstr1.
     *
     * @param addTo value of lfstr1
     */
    void addToLfstr1(String addTo);

    /**
     * Adds to the list of lfbool1.
     *
     * @param addTo value of lfbool1
     */
    void addToLfbool1(Boolean addTo);

    /**
     * Adds to the list of lfbool2.
     *
     * @param addTo value of lfbool2
     */
    void addToLfbool2(Boolean addTo);

    /**
     * Adds to the list of lfbool3.
     *
     * @param addTo value of lfbool3
     */
    void addToLfbool3(Boolean addTo);

    /**
     * Adds to the list of lfdecimal1.
     *
     * @param addTo value of lfdecimal1
     */
    void addToLfdecimal1(BigDecimal addTo);

    /**
     * Adds to the list of lfdecimal2.
     *
     * @param addTo value of lfdecimal2
     */
    void addToLfdecimal2(BigDecimal addTo);

    /**
     * Adds to the list of lfdecimal3.
     *
     * @param addTo value of lfdecimal3
     */
    void addToLfdecimal3(BigDecimal addTo);

    /**
     * Adds to the list of lfdecimal4.
     *
     * @param addTo value of lfdecimal4
     */
    void addToLfdecimal4(BigDecimal addTo);

    /**
     * Adds to the list of lfdecimal6.
     *
     * @param addTo value of lfdecimal6
     */
    void addToLfdecimal6(BigDecimal addTo);

    /**
     * Adds to the list of lfenum.
     *
     * @param addTo value of lfenum
     */
    void addToLfenum(LfenumEnum addTo);

    /**
     * Adds to the list of lfbits.
     *
     * @param addTo value of lfbits
     */
    void addToLfbits(BitSet addTo);

    /**
     * Adds to the list of lfbinary.
     *
     * @param addTo value of lfbinary
     */
    void addToLfbinary(byte[] addTo);

    /**
     * Adds to the list of lfref1.
     *
     * @param addTo value of lfref1
     */
    void addToLfref1(String addTo);

    /**
     * Adds to the list of lfref2.
     *
     * @param addTo value of lfref2
     */
    void addToLfref2(Byte addTo);

    /**
     * Adds to the list of lfempty.
     *
     * @param addTo value of lfempty
     */
    void addToLfempty(Boolean addTo);

    /**
     * Adds to the list of lfunion1.
     *
     * @param addTo value of lfunion1
     */
    void addToLfunion1(Lfunion1Union addTo);

    /**
     * Adds to the list of lfunion2.
     *
     * @param addTo value of lfunion2
     */
    void addToLfunion2(Lfunion2Union addTo);

    /**
     * Adds to the list of lfunion4.
     *
     * @param addTo value of lfunion4
     */
    void addToLfunion4(Lfunion4Union addTo);

    /**
     * Adds to the list of lfunion5.
     *
     * @param addTo value of lfunion5
     */
    void addToLfunion5(Lfunion5Union addTo);

    /**
     * Adds to the list of lfunion7.
     *
     * @param addTo value of lfunion7
     */
    void addToLfunion7(Tpdfun3 addTo);

    /**
     * Adds to the list of lfunion8.
     *
     * @param addTo value of lfunion8
     */
    void addToLfunion8(Lfunion8Union addTo);

    /**
     * Adds to the list of lfunion9.
     *
     * @param addTo value of lfunion9
     */
    void addToLfunion9(Lfunion9Union addTo);

    /**
     * Adds to the list of lfunion10.
     *
     * @param addTo value of lfunion10
     */
    void addToLfunion10(Lfunion10Union addTo);

    /**
     * Adds to the list of lfunion11.
     *
     * @param addTo value of lfunion11
     */
    void addToLfunion11(Lfunion11Union addTo);

    /**
     * Adds to the list of lfunion12.
     *
     * @param addTo value of lfunion12
     */
    void addToLfunion12(Tpdfun2 addTo);

    /**
     * Adds to the list of lfunion13.
     *
     * @param addTo value of lfunion13
     */
    void addToLfunion13(Tpdfbit addTo);

    /**
     * Adds to the list of lfunion14.
     *
     * @param addTo value of lfunion14
     */
    void addToLfunion14(Lfunion14Union addTo);

    /**
     * Adds to the list of identityref1.
     *
     * @param addTo value of identityref1
     */
    void addToIdentityref1(Class<? extends Iden> addTo);

    /**
     * Adds to the list of lfenum1.
     *
     * @param addTo value of lfenum1
     */
    void addToLfenum1(Lfenum1Enum addTo);

    /**
     * Adds to the list of lfenum2.
     *
     * @param addTo value of lfenum2
     */
    void addToLfenum2(Lfenum2Enum addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}