/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes;

/**
 * Represents the implementation of val.
 */
public abstract class Val extends Iden {

    /**
     * Returns the attribute val.
     *
     * @return val value of val
     */
    public static String valToString() {
        return "val";
    }

    /**
     * Returns the object of val fromString input String val.
     *
     * @param valInString value of input String
     * @return val
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("val")) {
            return Val.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}