/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.sample.sample;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.sample.sample.l1.C1;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of l1.
 */
public interface L1 extends Augmentable  {

    /**
     * Identify the leaf of L1.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf3.
         */
        LEAF3(1),
        /**
         * Represents leaf4.
         */
        LEAF4(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf3.
     *
     * @return leaf3 value of leaf3
     */
    String leaf3();

    /**
     * Returns the attribute leaf4.
     *
     * @return leaf4 list of leaf4
     */
    List<String> leaf4();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute c1.
     *
     * @return c1 value of c1
     */
    C1 c1();

    /**
     * Sets the attribute leaf3.
     *
     * @param leaf3 value of leaf3
     */
    void leaf3(String leaf3);

    /**
     * Sets the attribute leaf4.
     *
     * @param leaf4 list of leaf4
     */
    void leaf4(List<String> leaf4);

    /**
     * Sets the attribute c1.
     *
     * @param c1 value of c1
     */
    void c1(C1 c1);

    /**
     * Adds to the list of leaf4.
     *
     * @param addTo value of leaf4
     */
    void addToLeaf4(String addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}