/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type;

/**
 * Represents ENUM data of leaf6Enum.
 */
public enum Leaf6Enum {

    /**
     * Represents enum1.
     */
    ENUM1(0, "enum1"),

    /**
     * Represents enum2.
     */
    ENUM2(1, "enum2");

    private int leaf6Enum;
    private String schemaName;

    /**
     * Creates an instance of leaf6Enum.
     *
     * @param leaf6Enum value of leaf6Enum
     */
     Leaf6Enum(int leaf6Enum, String schemaName) {
        this.leaf6Enum = leaf6Enum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of leaf6Enum for.
     *
     * @param value value of leaf6Enum for
     * @return leaf6Enum for
     */
    public static Leaf6Enum of(int value) {
        switch (value) {
            case 0:
                return Leaf6Enum.ENUM1;
            case 1:
                return Leaf6Enum.ENUM2;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of leaf6Enum for.
     *
     * @param value value of leaf6Enum for
     * @return leaf6Enum for
     */
    public static Leaf6Enum of(String value) {
        switch (value) {
            case "enum1":
                return Leaf6Enum.ENUM1;
            case "enum2":
                return Leaf6Enum.ENUM2;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute leaf6Enum.
     *
     * @return leaf6Enum value of leaf6Enum
     */
    public int leaf6Enum() {
        return leaf6Enum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
