/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.tdef1;

import java.math.BigInteger;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.tdef1.tdef1union.Tdef1UnionEnum1;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of tdef1Union.
 */
public final class Tdef1Union {
    private BigInteger uint64;
    private Tdef1UnionEnum1 enumeration;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of tdef1Union.
     */
    private Tdef1Union() {
    }

    /**
     * Creates an instance of uint64.
     *
     * @param uint64 value of uint64
     */
    public Tdef1Union(BigInteger uint64) {
        setValue.set(0);
        this.uint64 = uint64;
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public Tdef1Union(Tdef1UnionEnum1 enumeration) {
        setValue.set(1);
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of tdef1Union for type uint64.
     *
     * @param value value of tdef1Union for type uint64
     * @return tdef1Union for type uint64
     */
    public static Tdef1Union of(BigInteger value) {
        return new Tdef1Union(value);
    }

    /**
     * Returns the object of tdef1Union for type enumeration.
     *
     * @param value value of tdef1Union for type enumeration
     * @return tdef1Union for type enumeration
     */
    public static Tdef1Union of(Tdef1UnionEnum1 value) {
        return new Tdef1Union(value);
    }

    /**
     * Returns the attribute uint64.
     *
     * @return uint64 value of uint64
     */
    public BigInteger uint64() {
        return uint64;
    }
    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public Tdef1UnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute uint64.
     *
     * @param uint64 value of uint64
     */
    public void uint64(BigInteger uint64) {
        this.uint64 = uint64;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(Tdef1UnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint64, enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tdef1Union) {
            Tdef1Union other = (Tdef1Union) obj;
            return
                Objects.deepEquals(uint64, other.uint64) &&
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return uint64.toString();
        }
        if (setValue.get(1)) {
            return enumeration.toString();
        }
        return null;
    }
    /**
     * Returns the object of tdef1Union fromString input String tdef1Union.
     *
     * @param valInString value of input String
     * @return tdef1Union
     */
    public static Tdef1Union fromString(String valInString) {
        try {
            BigInteger tmpVal = new BigInteger(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Tdef1UnionEnum1 tmpVal = Tdef1UnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
