/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.requestedtypeprofile.requestedtypechoice.dot1qcase;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of dot1q.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultDot1q extends InnerModelObject implements Dot1q {
    protected String physicalIf;
    protected int vlanId;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String physicalIf() {
        return physicalIf;
    }

    @Override
    public int vlanId() {
        return vlanId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void physicalIf(String physicalIf) {
        valueLeafFlags.set(LeafIdentifier.PHYSICALIF.getLeafIndex());
        this.physicalIf = physicalIf;
    }

    @Override
    public void vlanId(int vlanId) {
        valueLeafFlags.set(LeafIdentifier.VLANID.getLeafIndex());
        this.vlanId = vlanId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(physicalIf, vlanId, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDot1q) {
            DefaultDot1q other = (DefaultDot1q) obj;
            return
                Objects.deepEquals(physicalIf, other.physicalIf) &&
                Objects.deepEquals(vlanId, other.vlanId) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("physicalIf=" + physicalIf)
            .add("vlanId=" + vlanId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultDot1q.
     */
    public DefaultDot1q() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}