/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.requestedtypeprofile.requestedtypechoice;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.requestedtypeprofile.RequestedTypeChoice;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.requestedtypeprofile.requestedtypechoice.dot1qcase.Dot1q;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of dot1Qcase.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultDot1Qcase extends InnerModelObject implements Dot1Qcase {
    protected Dot1q dot1q;

    @Override
    public Dot1q dot1q() {
        return dot1q;
    }

    @Override
    public void dot1q(Dot1q dot1q) {
        this.dot1q = dot1q;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dot1q);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDot1Qcase) {
            DefaultDot1Qcase other = (DefaultDot1Qcase) obj;
            return
                Objects.deepEquals(dot1q, other.dot1q);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("dot1q=" + dot1q)
            .toString();
    }


    /**
     * Creates an instance of defaultDot1Qcase.
     */
    public DefaultDot1Qcase() {
    }

}