/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.rdrtprofile.siterole.customcase.custom;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of exportRt.
 */
public class ExportRtKeys implements KeyInfo<DefaultExportRt> {
    protected String exrtId;
    /**
     * Returns the attribute exrtId.
     *
     * @return exrtId value of exrtId
     */
    public String exrtId() {
        return exrtId;
    }

    /**
     * Sets the value to attribute exrtId.
     *
     * @param exrtId value of exrtId
     */
    public void exrtId(String exrtId) {
        this.exrtId = exrtId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(exrtId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExportRtKeys) {
            ExportRtKeys other = (ExportRtKeys) obj;
            return
                Objects.deepEquals(exrtId, other.exrtId);
        }
        return false;
    }
}