/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext;

import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.routedistinguisher.RouteDistinguisherUnion;
import java.util.Objects;

/**
 * Represents the implementation of routeDistinguisher.
 */
public final class RouteDistinguisher {

    private RouteDistinguisherUnion union;

    /**
     * Creates an instance of routeDistinguisher.
     */
    private RouteDistinguisher() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public RouteDistinguisher(RouteDistinguisherUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of routeDistinguisher for type union.
     *
     * @param value value of routeDistinguisher for type union
     * @return routeDistinguisher for type union
     */
    public static RouteDistinguisher of(RouteDistinguisherUnion value) {
        return new RouteDistinguisher(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public RouteDistinguisherUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(RouteDistinguisherUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouteDistinguisher) {
            RouteDistinguisher other = (RouteDistinguisher) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of routeDistinguisher fromString input String routeDistinguisher.
     *
     * @param valInString value of input String
     * @return routeDistinguisher
     */
    public static RouteDistinguisher fromString(String valInString) {
        try {
            RouteDistinguisherUnion tmpVal = RouteDistinguisherUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
