/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpgroupmappings.rpgroupmapping;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of providerManaged.
 */
public interface ProviderManaged extends Augmentable  {

    /**
     * Identify the leaf of ProviderManaged.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents enabled.
         */
        ENABLED(1),
        /**
         * Represents rpRedundancy.
         */
        RPREDUNDANCY(2),
        /**
         * Represents optimalTrafficDelivery.
         */
        OPTIMALTRAFFICDELIVERY(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute enabled.
     *
     * @return enabled value of enabled
     */
    boolean enabled();

    /**
     * Returns the attribute rpRedundancy.
     *
     * @return rpRedundancy value of rpRedundancy
     */
    boolean rpRedundancy();

    /**
     * Returns the attribute optimalTrafficDelivery.
     *
     * @return optimalTrafficDelivery value of optimalTrafficDelivery
     */
    boolean optimalTrafficDelivery();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute enabled.
     *
     * @param enabled value of enabled
     */
    void enabled(boolean enabled);

    /**
     * Sets the attribute rpRedundancy.
     *
     * @param rpRedundancy value of rpRedundancy
     */
    void rpRedundancy(boolean rpRedundancy);

    /**
     * Sets the attribute optimalTrafficDelivery.
     *
     * @param optimalTrafficDelivery value of optimalTrafficDelivery
     */
    void optimalTrafficDelivery(boolean optimalTrafficDelivery);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}