/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses.cloudaccess;

import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses.cloudaccess.deniedsites.DeniedSite;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of deniedSites.
 */
public interface DeniedSites extends Augmentable  {

    /**
     * Returns the attribute deniedSite.
     *
     * @return deniedSite list of deniedSite
     */
    List<DeniedSite> deniedSite();

    /**
     * Sets the attribute deniedSite.
     *
     * @param deniedSite list of deniedSite
     */
    void deniedSite(List<DeniedSite> deniedSite);

    /**
     * Adds to the list of deniedSite.
     *
     * @param addTo value of deniedSite
     */
    void addToDeniedSite(DeniedSite addTo);

}