/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses.cloudaccess.AuthorizedSites;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses.cloudaccess.DeniedSites;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of cloudAccess.
 */
public interface CloudAccess extends Augmentable  {

    /**
     * Identify the leaf of CloudAccess.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents cloudIdentifier.
         */
        CLOUDIDENTIFIER(1),
        /**
         * Represents natEnabled.
         */
        NATENABLED(2),
        /**
         * Represents customerNatAddress.
         */
        CUSTOMERNATADDRESS(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute cloudIdentifier.
     *
     * @return cloudIdentifier value of cloudIdentifier
     */
    String cloudIdentifier();

    /**
     * Returns the attribute natEnabled.
     *
     * @return natEnabled value of natEnabled
     */
    boolean natEnabled();

    /**
     * Returns the attribute customerNatAddress.
     *
     * @return customerNatAddress value of customerNatAddress
     */
    Ipv4Address customerNatAddress();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute authorizedSites.
     *
     * @return authorizedSites value of authorizedSites
     */
    AuthorizedSites authorizedSites();

    /**
     * Returns the attribute deniedSites.
     *
     * @return deniedSites value of deniedSites
     */
    DeniedSites deniedSites();

    /**
     * Sets the attribute cloudIdentifier.
     *
     * @param cloudIdentifier value of cloudIdentifier
     */
    void cloudIdentifier(String cloudIdentifier);

    /**
     * Sets the attribute natEnabled.
     *
     * @param natEnabled value of natEnabled
     */
    void natEnabled(boolean natEnabled);

    /**
     * Sets the attribute customerNatAddress.
     *
     * @param customerNatAddress value of customerNatAddress
     */
    void customerNatAddress(Ipv4Address customerNatAddress);

    /**
     * Sets the attribute authorizedSites.
     *
     * @param authorizedSites value of authorizedSites
     */
    void authorizedSites(AuthorizedSites authorizedSites);

    /**
     * Sets the attribute deniedSites.
     *
     * @param deniedSites value of deniedSites
     */
    void deniedSites(DeniedSites deniedSites);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}