/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosclassificationpolicy.rule.matchtype;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.CustomerApplication;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosclassificationpolicy.rule.MatchType;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of matchApplication.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultMatchApplication extends InnerModelObject implements MatchApplication {
    protected Class<? extends CustomerApplication> matchApplication;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Class<? extends CustomerApplication> matchApplication() {
        return matchApplication;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void matchApplication(Class<? extends CustomerApplication> matchApplication) {
        valueLeafFlags.set(LeafIdentifier.MATCHAPPLICATION.getLeafIndex());
        this.matchApplication = matchApplication;
    }

    @Override
    public int hashCode() {
        return Objects.hash(matchApplication, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMatchApplication) {
            DefaultMatchApplication other = (DefaultMatchApplication) obj;
            return
                Objects.deepEquals(matchApplication, other.matchApplication) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("matchApplication=" + matchApplication)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultMatchApplication.
     */
    public DefaultMatchApplication() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}