/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of qosProfile.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultQosProfile extends InnerModelObject implements QosProfile {
    protected org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosprofile.QosProfile qosProfile;

    @Override
    public org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosprofile.QosProfile qosProfile() {
        return qosProfile;
    }

    @Override
    public void qosProfile(org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosprofile.QosProfile qosProfile) {
        this.qosProfile = qosProfile;
    }

    @Override
    public int hashCode() {
        return Objects.hash(qosProfile);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultQosProfile) {
            DefaultQosProfile other = (DefaultQosProfile) obj;
            return
                Objects.deepEquals(qosProfile, other.qosProfile);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("qosProfile=" + qosProfile)
            .toString();
    }


    /**
     * Creates an instance of defaultQosProfile.
     */
    public DefaultQosProfile() {
    }

}