/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast.multicast;

/**
 * Represents ENUM data of multicastSiteTypeEnum.
 */
public enum MulticastSiteTypeEnum {

    /**
     * Represents receiver-only.
     */
    RECEIVER_ONLY(0, "receiver-only"),

    /**
     * Represents source-only.
     */
    SOURCE_ONLY(1, "source-only"),

    /**
     * Represents source-receiver.
     */
    SOURCE_RECEIVER(2, "source-receiver");

    private int multicastSiteTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of multicastSiteTypeEnum.
     *
     * @param multicastSiteTypeEnum value of multicastSiteTypeEnum
     */
     MulticastSiteTypeEnum(int multicastSiteTypeEnum, String schemaName) {
        this.multicastSiteTypeEnum = multicastSiteTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of multicastSiteTypeEnum for.
     *
     * @param value value of multicastSiteTypeEnum for
     * @return multicastSiteTypeEnum for
     */
    public static MulticastSiteTypeEnum of(int value) {
        switch (value) {
            case 0:
                return MulticastSiteTypeEnum.RECEIVER_ONLY;
            case 1:
                return MulticastSiteTypeEnum.SOURCE_ONLY;
            case 2:
                return MulticastSiteTypeEnum.SOURCE_RECEIVER;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of multicastSiteTypeEnum for.
     *
     * @param value value of multicastSiteTypeEnum for
     * @return multicastSiteTypeEnum for
     */
    public static MulticastSiteTypeEnum of(String value) {
        switch (value) {
            case "receiver-only":
                return MulticastSiteTypeEnum.RECEIVER_ONLY;
            case "source-only":
                return MulticastSiteTypeEnum.SOURCE_ONLY;
            case "source-receiver":
                return MulticastSiteTypeEnum.SOURCE_RECEIVER;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute multicastSiteTypeEnum.
     *
     * @return multicastSiteTypeEnum value of multicastSiteTypeEnum
     */
    public int multicastSiteTypeEnum() {
        return multicastSiteTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
