/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservice;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicempls.Carrierscarrier;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservicemulticast.Multicast;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.Qos;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of service.
 */
public interface Service extends Augmentable  {

    /**
     * Identify the leaf of Service.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents svcInputBandwidth.
         */
        SVCINPUTBANDWIDTH(1),
        /**
         * Represents svcOutputBandwidth.
         */
        SVCOUTPUTBANDWIDTH(2),
        /**
         * Represents svcMtu.
         */
        SVCMTU(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute svcInputBandwidth.
     *
     * @return svcInputBandwidth value of svcInputBandwidth
     */
    long svcInputBandwidth();

    /**
     * Returns the attribute svcOutputBandwidth.
     *
     * @return svcOutputBandwidth value of svcOutputBandwidth
     */
    long svcOutputBandwidth();

    /**
     * Returns the attribute svcMtu.
     *
     * @return svcMtu value of svcMtu
     */
    int svcMtu();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute qos.
     *
     * @return qos value of qos
     */
    Qos qos();

    /**
     * Returns the attribute carrierscarrier.
     *
     * @return carrierscarrier value of carrierscarrier
     */
    Carrierscarrier carrierscarrier();

    /**
     * Returns the attribute multicast.
     *
     * @return multicast value of multicast
     */
    Multicast multicast();

    /**
     * Sets the attribute svcInputBandwidth.
     *
     * @param svcInputBandwidth value of svcInputBandwidth
     */
    void svcInputBandwidth(long svcInputBandwidth);

    /**
     * Sets the attribute svcOutputBandwidth.
     *
     * @param svcOutputBandwidth value of svcOutputBandwidth
     */
    void svcOutputBandwidth(long svcOutputBandwidth);

    /**
     * Sets the attribute svcMtu.
     *
     * @param svcMtu value of svcMtu
     */
    void svcMtu(int svcMtu);

    /**
     * Sets the attribute qos.
     *
     * @param qos value of qos
     */
    void qos(Qos qos);

    /**
     * Sets the attribute carrierscarrier.
     *
     * @param carrierscarrier value of carrierscarrier
     */
    void carrierscarrier(Carrierscarrier carrierscarrier);

    /**
     * Sets the attribute multicast.
     *
     * @param multicast value of multicast
     */
    void multicast(Multicast multicast);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}