/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.yangautoprefixstatic.cascadedlanprefixes;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Prefix;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of ipv4LanPrefixes.
 */
public class Ipv4LanPrefixesKeys implements KeyInfo<DefaultIpv4LanPrefixes> {
    protected Ipv4Prefix lan;
    protected Ipv4Address nextHop;
    /**
     * Returns the attribute lan.
     *
     * @return lan value of lan
     */
    public Ipv4Prefix lan() {
        return lan;
    }

    /**
     * Sets the value to attribute lan.
     *
     * @param lan value of lan
     */
    public void lan(Ipv4Prefix lan) {
        this.lan = lan;
    }

    /**
     * Returns the attribute nextHop.
     *
     * @return nextHop value of nextHop
     */
    public Ipv4Address nextHop() {
        return nextHop;
    }

    /**
     * Sets the value to attribute nextHop.
     *
     * @param nextHop value of nextHop
     */
    public void nextHop(Ipv4Address nextHop) {
        this.nextHop = nextHop;
    }


    @Override
    public int hashCode() {
        return Objects.hash(lan, nextHop);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ipv4LanPrefixesKeys) {
            Ipv4LanPrefixesKeys other = (Ipv4LanPrefixesKeys) obj;
            return
                Objects.deepEquals(lan, other.lan) &&
                Objects.deepEquals(nextHop, other.nextHop);
        }
        return false;
    }
}