/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.yangautoprefixstatic.cascadedlanprefixes;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Prefix;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of ipv4LanPrefixes.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIpv4LanPrefixes extends InnerModelObject 
        implements Ipv4LanPrefixes, MultiInstanceObject<Ipv4LanPrefixesKeys> {
    protected Ipv4Prefix lan;
    protected String lanTag;
    protected Ipv4Address nextHop;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Ipv4Prefix lan() {
        return lan;
    }

    @Override
    public String lanTag() {
        return lanTag;
    }

    @Override
    public Ipv4Address nextHop() {
        return nextHop;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void lan(Ipv4Prefix lan) {
        valueLeafFlags.set(LeafIdentifier.LAN.getLeafIndex());
        this.lan = lan;
    }

    @Override
    public void lanTag(String lanTag) {
        valueLeafFlags.set(LeafIdentifier.LANTAG.getLeafIndex());
        this.lanTag = lanTag;
    }

    @Override
    public void nextHop(Ipv4Address nextHop) {
        valueLeafFlags.set(LeafIdentifier.NEXTHOP.getLeafIndex());
        this.nextHop = nextHop;
    }

    @Override
    public int hashCode() {
        return Objects.hash(lan, lanTag, nextHop, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpv4LanPrefixes) {
            DefaultIpv4LanPrefixes other = (DefaultIpv4LanPrefixes) obj;
            return
                Objects.deepEquals(lan, other.lan) &&
                Objects.deepEquals(lanTag, other.lanTag) &&
                Objects.deepEquals(nextHop, other.nextHop) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("lan=" + lan)
            .add("lanTag=" + lanTag)
            .add("nextHop=" + nextHop)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultIpv4LanPrefixes.
     */
    public DefaultIpv4LanPrefixes() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}