/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.ospf;

import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.ospf.shamlinks.ShamLink;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of shamLinks.
 */
public interface ShamLinks extends Augmentable  {

    /**
     * Returns the attribute shamLink.
     *
     * @return shamLink list of shamLink
     */
    List<ShamLink> shamLink();

    /**
     * Sets the attribute shamLink.
     *
     * @param shamLink list of shamLink
     */
    void shamLink(List<ShamLink> shamLink);

    /**
     * Adds to the list of shamLink.
     *
     * @param addTo value of shamLink
     */
    void addToShamLink(ShamLink addTo);

}