/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.ipconnection.oam;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.ipconnection.oam.bfd.Holdtime;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of bfd.
 */
public interface Bfd extends Augmentable  {

    /**
     * Identify the leaf of Bfd.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents bfdEnabled.
         */
        BFDENABLED(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute bfdEnabled.
     *
     * @return bfdEnabled value of bfdEnabled
     */
    boolean bfdEnabled();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute holdtime.
     *
     * @return holdtime value of holdtime
     */
    Holdtime holdtime();

    /**
     * Sets the attribute bfdEnabled.
     *
     * @param bfdEnabled value of bfdEnabled
     */
    void bfdEnabled(boolean bfdEnabled);

    /**
     * Sets the attribute holdtime.
     *
     * @param holdtime value of holdtime
     */
    void holdtime(Holdtime holdtime);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}