/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteattachmentipconnection.ipconnection.ipv6;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv6Address;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of addresses.
 */
public interface Addresses extends Augmentable  {

    /**
     * Identify the leaf of Addresses.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents providerAddress.
         */
        PROVIDERADDRESS(1),
        /**
         * Represents customerAddress.
         */
        CUSTOMERADDRESS(2),
        /**
         * Represents mask.
         */
        MASK(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute providerAddress.
     *
     * @return providerAddress value of providerAddress
     */
    Ipv6Address providerAddress();

    /**
     * Returns the attribute customerAddress.
     *
     * @return customerAddress value of customerAddress
     */
    Ipv6Address customerAddress();

    /**
     * Returns the attribute mask.
     *
     * @return mask value of mask
     */
    short mask();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute providerAddress.
     *
     * @param providerAddress value of providerAddress
     */
    void providerAddress(Ipv6Address providerAddress);

    /**
     * Sets the attribute customerAddress.
     *
     * @param customerAddress value of customerAddress
     */
    void customerAddress(Ipv6Address customerAddress);

    /**
     * Sets the attribute mask.
     *
     * @param mask value of mask
     */
    void mask(short mask);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}