/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc;

import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites.Site;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of sites.
 */
public interface Sites extends Augmentable  {

    /**
     * Returns the attribute site.
     *
     * @return site list of site
     */
    List<Site> site();

    /**
     * Sets the attribute site.
     *
     * @param site list of site
     */
    void site(List<Site> site);

    /**
     * Adds to the list of site.
     *
     * @param addTo value of site
     */
    void addToSite(Site addTo);

}