/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.Con1;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of test.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTest extends InnerModelObject implements Test {
    protected String l;
    protected BitSet valueLeafFlags = new BitSet();
    protected Con1 con1;

    @Override
    public String l() {
        return l;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Con1 con1() {
        return con1;
    }

    @Override
    public void l(String l) {
        valueLeafFlags.set(LeafIdentifier.L.getLeafIndex());
        this.l = l;
    }

    @Override
    public void con1(Con1 con1) {
        this.con1 = con1;
    }

    @Override
    public int hashCode() {
        return Objects.hash(l, valueLeafFlags, con1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTest) {
            DefaultTest other = (DefaultTest) obj;
            return
                Objects.deepEquals(l, other.l) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(con1, other.con1);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("l=" + l)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("con1=" + con1)
            .toString();
    }


    /**
     * Creates an instance of defaultTest.
     */
    public DefaultTest() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}