/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.event.event;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.event.event.event.C;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of event.
 */
public class DefaultEvent extends InnerModelObject implements Event {
    protected C c;

    @Override
    public C c() {
        return c;
    }

    @Override
    public void c(C c) {
        this.c = c;
    }

    @Override
    public int hashCode() {
        return Objects.hash(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEvent) {
            DefaultEvent other = (DefaultEvent) obj;
            return
                Objects.deepEquals(c, other.c);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("c=" + c)
            .toString();
    }


    /**
     * Creates an instance of defaultEvent.
     */
    public DefaultEvent() {
    }

}