/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524.enumlistkeytest;

import org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524.enumlistkeytest.enumlist.EnumleafEnum;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of enumList.
 */
public class EnumListKeys implements KeyInfo<DefaultEnumList> {
    protected EnumleafEnum enumleaf;
    /**
     * Returns the attribute enumleaf.
     *
     * @return enumleaf value of enumleaf
     */
    public EnumleafEnum enumleaf() {
        return enumleaf;
    }

    /**
     * Sets the value to attribute enumleaf.
     *
     * @param enumleaf value of enumleaf
     */
    public void enumleaf(EnumleafEnum enumleaf) {
        this.enumleaf = enumleaf;
    }


    @Override
    public int hashCode() {
        return Objects.hash(enumleaf);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EnumListKeys) {
            EnumListKeys other = (EnumListKeys) obj;
            return
                Objects.deepEquals(enumleaf, other.enumleaf);
        }
        return false;
    }
}