/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524;

import java.util.List;
import org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524.enumlistkeytest.EnumList;

/**
 * Abstraction of an entity which represents the functionality of enumListKeyTest.
 */
public interface EnumListKeyTest {

    /**
     * Returns the attribute enumList.
     *
     * @return enumList list of enumList
     */
    List<EnumList> enumList();

    /**
     * Sets the attribute enumList.
     *
     * @param enumList list of enumList
     */
    void enumList(List<EnumList> enumList);

    /**
     * Adds to the list of enumList.
     *
     * @param addTo value of enumList
     */
    void addToEnumList(EnumList addTo);

}