/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.tetopologyeventtype;

/**
 * Represents ENUM data of teTopologyEventTypeEnum.
 */
public enum TeTopologyEventTypeEnum {

    /**
     * Represents add.
     */
    ADD(0, "add"),

    /**
     * Represents remove.
     */
    REMOVE(1, "remove"),

    /**
     * Represents update.
     */
    UPDATE(2, "update");

    private int teTopologyEventTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of teTopologyEventTypeEnum.
     *
     * @param teTopologyEventTypeEnum value of teTopologyEventTypeEnum
     */
     TeTopologyEventTypeEnum(int teTopologyEventTypeEnum, String schemaName) {
        this.teTopologyEventTypeEnum = teTopologyEventTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of teTopologyEventTypeEnum for.
     *
     * @param value value of teTopologyEventTypeEnum for
     * @return teTopologyEventTypeEnum for
     */
    public static TeTopologyEventTypeEnum of(int value) {
        switch (value) {
            case 0:
                return TeTopologyEventTypeEnum.ADD;
            case 1:
                return TeTopologyEventTypeEnum.REMOVE;
            case 2:
                return TeTopologyEventTypeEnum.UPDATE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of teTopologyEventTypeEnum for.
     *
     * @param value value of teTopologyEventTypeEnum for
     * @return teTopologyEventTypeEnum for
     */
    public static TeTopologyEventTypeEnum of(String value) {
        switch (value) {
            case "add":
                return TeTopologyEventTypeEnum.ADD;
            case "remove":
                return TeTopologyEventTypeEnum.REMOVE;
            case "update":
                return TeTopologyEventTypeEnum.UPDATE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute teTopologyEventTypeEnum.
     *
     * @return teTopologyEventTypeEnum value of teTopologyEventTypeEnum
     */
    public int teTopologyEventTypeEnum() {
        return teTopologyEventTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
