/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.teadminstatus;

/**
 * Represents ENUM data of teAdminStatusEnum.
 */
public enum TeAdminStatusEnum {

    /**
     * Represents up.
     */
    UP(0, "up"),

    /**
     * Represents down.
     */
    DOWN(1, "down"),

    /**
     * Represents testing.
     */
    TESTING(2, "testing"),

    /**
     * Represents preparing-maintenance.
     */
    PREPARING_MAINTENANCE(3, "preparing-maintenance"),

    /**
     * Represents maintenance.
     */
    MAINTENANCE(4, "maintenance");

    private int teAdminStatusEnum;
    private String schemaName;

    /**
     * Creates an instance of teAdminStatusEnum.
     *
     * @param teAdminStatusEnum value of teAdminStatusEnum
     */
     TeAdminStatusEnum(int teAdminStatusEnum, String schemaName) {
        this.teAdminStatusEnum = teAdminStatusEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of teAdminStatusEnum for.
     *
     * @param value value of teAdminStatusEnum for
     * @return teAdminStatusEnum for
     */
    public static TeAdminStatusEnum of(int value) {
        switch (value) {
            case 0:
                return TeAdminStatusEnum.UP;
            case 1:
                return TeAdminStatusEnum.DOWN;
            case 2:
                return TeAdminStatusEnum.TESTING;
            case 3:
                return TeAdminStatusEnum.PREPARING_MAINTENANCE;
            case 4:
                return TeAdminStatusEnum.MAINTENANCE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of teAdminStatusEnum for.
     *
     * @param value value of teAdminStatusEnum for
     * @return teAdminStatusEnum for
     */
    public static TeAdminStatusEnum of(String value) {
        switch (value) {
            case "up":
                return TeAdminStatusEnum.UP;
            case "down":
                return TeAdminStatusEnum.DOWN;
            case "testing":
                return TeAdminStatusEnum.TESTING;
            case "preparing-maintenance":
                return TeAdminStatusEnum.PREPARING_MAINTENANCE;
            case "maintenance":
                return TeAdminStatusEnum.MAINTENANCE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute teAdminStatusEnum.
     *
     * @return teAdminStatusEnum value of teAdminStatusEnum
     */
    public int teAdminStatusEnum() {
        return teAdminStatusEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
