/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.recordroutesubobject.type;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.recordroutesubobject.Type;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ipAddress.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIpAddress extends InnerModelObject implements IpAddress {
    protected org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress ipAddress;
    protected byte[] ipFlags;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress ipAddress() {
        return ipAddress;
    }

    @Override
    public byte[] ipFlags() {
        return ipFlags;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void ipAddress(org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress ipAddress) {
        valueLeafFlags.set(LeafIdentifier.IPADDRESS.getLeafIndex());
        this.ipAddress = ipAddress;
    }

    @Override
    public void ipFlags(byte[] ipFlags) {
        valueLeafFlags.set(LeafIdentifier.IPFLAGS.getLeafIndex());
        this.ipFlags = ipFlags;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ipAddress, ipFlags, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpAddress) {
            DefaultIpAddress other = (DefaultIpAddress) obj;
            return
                Objects.deepEquals(ipAddress, other.ipAddress) &&
                Objects.deepEquals(ipFlags, other.ipFlags) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("ipAddress=" + ipAddress)
            .add("ipFlags=" + ipFlags)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultIpAddress.
     */
    public DefaultIpAddress() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}