/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.performancemetriccontainer;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.performancemetriccontainer.performancemetric.Measurement;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.performancemetriccontainer.performancemetric.Normality;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.performancemetricthrottlecontainer.Throttle;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of performanceMetric.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultPerformanceMetric extends InnerModelObject implements PerformanceMetric {
    protected Measurement measurement;
    protected Normality normality;
    protected Throttle throttle;

    @Override
    public Measurement measurement() {
        return measurement;
    }

    @Override
    public Normality normality() {
        return normality;
    }

    @Override
    public Throttle throttle() {
        return throttle;
    }

    @Override
    public void measurement(Measurement measurement) {
        this.measurement = measurement;
    }

    @Override
    public void normality(Normality normality) {
        this.normality = normality;
    }

    @Override
    public void throttle(Throttle throttle) {
        this.throttle = throttle;
    }

    @Override
    public int hashCode() {
        return Objects.hash(measurement, normality, throttle);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPerformanceMetric) {
            DefaultPerformanceMetric other = (DefaultPerformanceMetric) obj;
            return
                Objects.deepEquals(measurement, other.measurement) &&
                Objects.deepEquals(normality, other.normality) &&
                Objects.deepEquals(throttle, other.throttle);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("measurement=" + measurement)
            .add("normality=" + normality)
            .add("throttle=" + throttle)
            .toString();
    }


    /**
     * Creates an instance of defaultPerformanceMetric.
     */
    public DefaultPerformanceMetric() {
    }

}