/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DottedQuad;
import java.util.Objects;

/**
 * Represents the implementation of teNodeId.
 */
public final class TeNodeId {

    private DottedQuad dottedQuad;

    /**
     * Creates an instance of teNodeId.
     */
    private TeNodeId() {
    }

    /**
     * Creates an instance of dottedQuad.
     *
     * @param dottedQuad value of dottedQuad
     */
    public TeNodeId(DottedQuad dottedQuad) {
        this.dottedQuad = dottedQuad;
    }

    /**
     * Returns the object of teNodeId for type dottedQuad.
     *
     * @param value value of teNodeId for type dottedQuad
     * @return teNodeId for type dottedQuad
     */
    public static TeNodeId of(DottedQuad value) {
        return new TeNodeId(value);
    }

    /**
     * Returns the attribute dottedQuad.
     *
     * @return dottedQuad value of dottedQuad
     */
    public DottedQuad dottedQuad() {
        return dottedQuad;
    }
    /**
     * Sets the attribute dottedQuad.
     *
     * @param dottedQuad value of dottedQuad
     */
    public void dottedQuad(DottedQuad dottedQuad) {
        this.dottedQuad = dottedQuad;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dottedQuad);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeNodeId) {
            TeNodeId other = (TeNodeId) obj;
            return
                Objects.deepEquals(dottedQuad, other.dottedQuad);
        }
        return false;
    }

    @Override
    public String toString() {
        return dottedQuad.toString();
    }
    /**
     * Returns the object of teNodeId fromString input String teNodeId.
     *
     * @param valInString value of input String
     * @return teNodeId
     */
    public static TeNodeId fromString(String valInString) {
        try {
            DottedQuad tmpVal = DottedQuad.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
