/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.teadminstatus.TeAdminStatusEnum;
import java.util.Objects;

/**
 * Represents the implementation of teAdminStatus.
 */
public final class TeAdminStatus {

    private TeAdminStatusEnum enumeration;

    /**
     * Creates an instance of teAdminStatus.
     */
    private TeAdminStatus() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TeAdminStatus(TeAdminStatusEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of teAdminStatus for type enumeration.
     *
     * @param value value of teAdminStatus for type enumeration
     * @return teAdminStatus for type enumeration
     */
    public static TeAdminStatus of(TeAdminStatusEnum value) {
        return new TeAdminStatus(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TeAdminStatusEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TeAdminStatusEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeAdminStatus) {
            TeAdminStatus other = (TeAdminStatus) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of teAdminStatus fromString input String teAdminStatus.
     *
     * @param valInString value of input String
     * @return teAdminStatus
     */
    public static TeAdminStatus fromString(String valInString) {
        try {
            TeAdminStatusEnum tmpVal = TeAdminStatusEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
