/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of pathComputationMethod.
 */
public abstract class PathComputationMethod {

    /**
     * Returns the attribute path-computation-method.
     *
     * @return path-computation-method value of path-computation-method
     */
    public static String pathComputationMethodToString() {
        return "path-computation-method";
    }

    /**
     * Returns the object of pathComputationMethod fromString input String pathComputationMethod.
     *
     * @param valInString value of input String
     * @return pathComputationMethod
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("path-computation-method")) {
            return PathComputationMethod.class;
        } else if (valInString.equals("path-locally-computed")) {
            return PathLocallyComputed.class;
        } else if (valInString.equals("path-externally-queried")) {
            return PathExternallyQueried.class;
        } else if (valInString.equals("path-explicitly-defined")) {
            return PathExplicitlyDefined.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}