/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of lspMetricRelative.
 */
public abstract class LspMetricRelative extends LspMetricType {

    /**
     * Returns the attribute lSP_METRIC_RELATIVE.
     *
     * @return lSP_METRIC_RELATIVE value of lSP_METRIC_RELATIVE
     */
    public static String lspMetricRelativeToString() {
        return "LSP_METRIC_RELATIVE";
    }

    /**
     * Returns the object of lspMetricRelative fromString input String lspMetricRelative.
     *
     * @param valInString value of input String
     * @return lspMetricRelative
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("LSP_METRIC_RELATIVE")) {
            return LspMetricRelative.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}