/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of lspMetricInherited.
 */
public abstract class LspMetricInherited extends LspMetricType {

    /**
     * Returns the attribute lSP_METRIC_INHERITED.
     *
     * @return lSP_METRIC_INHERITED value of lSP_METRIC_INHERITED
     */
    public static String lspMetricInheritedToString() {
        return "LSP_METRIC_INHERITED";
    }

    /**
     * Returns the object of lspMetricInherited fromString input String lspMetricInherited.
     *
     * @param valInString value of input String
     * @return lspMetricInherited
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("LSP_METRIC_INHERITED")) {
            return LspMetricInherited.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}