/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of lspEncodingPacket.
 */
public abstract class LspEncodingPacket extends LspEncodingTypes {

    /**
     * Returns the attribute lsp-encoding-packet.
     *
     * @return lsp-encoding-packet value of lsp-encoding-packet
     */
    public static String lspEncodingPacketToString() {
        return "lsp-encoding-packet";
    }

    /**
     * Returns the object of lspEncodingPacket fromString input String lspEncodingPacket.
     *
     * @param valInString value of input String
     * @return lspEncodingPacket
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("lsp-encoding-packet")) {
            return LspEncodingPacket.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}