/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.admingroups.AdminGroupsUnion;
import java.util.Objects;

/**
 * Represents the implementation of adminGroups.
 */
public final class AdminGroups {

    private AdminGroupsUnion union;

    /**
     * Creates an instance of adminGroups.
     */
    private AdminGroups() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public AdminGroups(AdminGroupsUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of adminGroups for type union.
     *
     * @param value value of adminGroups for type union
     * @return adminGroups for type union
     */
    public static AdminGroups of(AdminGroupsUnion value) {
        return new AdminGroups(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public AdminGroupsUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(AdminGroupsUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AdminGroups) {
            AdminGroups other = (AdminGroups) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of adminGroups fromString input String adminGroups.
     *
     * @param valInString value of input String
     * @return adminGroups
     */
    public static AdminGroups fromString(String valInString) {
        try {
            AdminGroupsUnion tmpVal = AdminGroupsUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
