/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.vpnroutetargets;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.RouteTarget;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of vpnTarget.
 */
public class VpnTargetKeys implements KeyInfo<DefaultVpnTarget> {
    protected RouteTarget routeTarget;
    /**
     * Returns the attribute routeTarget.
     *
     * @return routeTarget value of routeTarget
     */
    public RouteTarget routeTarget() {
        return routeTarget;
    }

    /**
     * Sets the value to attribute routeTarget.
     *
     * @param routeTarget value of routeTarget
     */
    public void routeTarget(RouteTarget routeTarget) {
        this.routeTarget = routeTarget;
    }


    @Override
    public int hashCode() {
        return Objects.hash(routeTarget);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VpnTargetKeys) {
            VpnTargetKeys other = (VpnTargetKeys) obj;
            return
                Objects.deepEquals(routeTarget, other.routeTarget);
        }
        return false;
    }
}