/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervalueseconds32.timervalueseconds32union;

/**
 * Represents ENUM data of timerValueSeconds32UnionEnum1.
 */
public enum TimerValueSeconds32UnionEnum1 {

    /**
     * Represents infinity.
     */
    INFINITY(0, "infinity"),

    /**
     * Represents not-set.
     */
    NOT_SET(1, "not-set");

    private int timerValueSeconds32UnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of timerValueSeconds32UnionEnum1.
     *
     * @param timerValueSeconds32UnionEnum1 value of timerValueSeconds32UnionEnum1
     */
     TimerValueSeconds32UnionEnum1(int timerValueSeconds32UnionEnum1, String schemaName) {
        this.timerValueSeconds32UnionEnum1 = timerValueSeconds32UnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of timerValueSeconds32UnionEnum1 for.
     *
     * @param value value of timerValueSeconds32UnionEnum1 for
     * @return timerValueSeconds32UnionEnum1 for
     */
    public static TimerValueSeconds32UnionEnum1 of(int value) {
        switch (value) {
            case 0:
                return TimerValueSeconds32UnionEnum1.INFINITY;
            case 1:
                return TimerValueSeconds32UnionEnum1.NOT_SET;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of timerValueSeconds32UnionEnum1 for.
     *
     * @param value value of timerValueSeconds32UnionEnum1 for
     * @return timerValueSeconds32UnionEnum1 for
     */
    public static TimerValueSeconds32UnionEnum1 of(String value) {
        switch (value) {
            case "infinity":
                return TimerValueSeconds32UnionEnum1.INFINITY;
            case "not-set":
                return TimerValueSeconds32UnionEnum1.NOT_SET;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute timerValueSeconds32UnionEnum1.
     *
     * @return timerValueSeconds32UnionEnum1 value of timerValueSeconds32UnionEnum1
     */
    public int timerValueSeconds32UnionEnum1() {
        return timerValueSeconds32UnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
