/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervalueseconds32;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervalueseconds32.timervalueseconds32union.TimerValueSeconds32UnionEnum1;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of timerValueSeconds32Union.
 */
public final class TimerValueSeconds32Union {
    private long uint32;
    private TimerValueSeconds32UnionEnum1 enumeration;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of timerValueSeconds32Union.
     */
    private TimerValueSeconds32Union() {
    }

    /**
     * Creates an instance of uint32.
     *
     * @param uint32 value of uint32
     */
    public TimerValueSeconds32Union(long uint32) {
        setValue.set(0);
        this.uint32 = uint32;
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TimerValueSeconds32Union(TimerValueSeconds32UnionEnum1 enumeration) {
        setValue.set(1);
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of timerValueSeconds32Union for type uint32.
     *
     * @param value value of timerValueSeconds32Union for type uint32
     * @return timerValueSeconds32Union for type uint32
     */
    public static TimerValueSeconds32Union of(long value) {
        return new TimerValueSeconds32Union(value);
    }

    /**
     * Returns the object of timerValueSeconds32Union for type enumeration.
     *
     * @param value value of timerValueSeconds32Union for type enumeration
     * @return timerValueSeconds32Union for type enumeration
     */
    public static TimerValueSeconds32Union of(TimerValueSeconds32UnionEnum1 value) {
        return new TimerValueSeconds32Union(value);
    }

    /**
     * Returns the attribute uint32.
     *
     * @return uint32 value of uint32
     */
    public long uint32() {
        return uint32;
    }
    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TimerValueSeconds32UnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute uint32.
     *
     * @param uint32 value of uint32
     */
    public void uint32(long uint32) {
        this.uint32 = uint32;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TimerValueSeconds32UnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint32, enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimerValueSeconds32Union) {
            TimerValueSeconds32Union other = (TimerValueSeconds32Union) obj;
            return
                Objects.deepEquals(uint32, other.uint32) &&
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint32);
        }
        if (setValue.get(1)) {
            return enumeration.toString();
        }
        return null;
    }
    /**
     * Returns the object of timerValueSeconds32Union fromString input String timerValueSeconds32Union.
     *
     * @param valInString value of input String
     * @return timerValueSeconds32Union
     */
    public static TimerValueSeconds32Union fromString(String valInString) {
        try {
            long tmpVal = Long.parseLong(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            TimerValueSeconds32UnionEnum1 tmpVal = TimerValueSeconds32UnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
