/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.mplslabelstack.mplslabelstack;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.MplsLabel;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of entry.
 */
public interface Entry extends Augmentable  {

    /**
     * Identify the leaf of Entry.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents id.
         */
        ID(1),
        /**
         * Represents label.
         */
        LABEL(2),
        /**
         * Represents ttl.
         */
        TTL(3),
        /**
         * Represents trafficClass.
         */
        TRAFFICCLASS(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    short id();

    /**
     * Returns the attribute label.
     *
     * @return label value of label
     */
    MplsLabel label();

    /**
     * Returns the attribute ttl.
     *
     * @return ttl value of ttl
     */
    short ttl();

    /**
     * Returns the attribute trafficClass.
     *
     * @return trafficClass value of trafficClass
     */
    short trafficClass();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute id.
     *
     * @param id value of id
     */
    void id(short id);

    /**
     * Sets the attribute label.
     *
     * @param label value of label
     */
    void label(MplsLabel label);

    /**
     * Sets the attribute ttl.
     *
     * @param ttl value of ttl
     */
    void ttl(short ttl);

    /**
     * Sets the attribute trafficClass.
     *
     * @param trafficClass value of trafficClass
     */
    void trafficClass(short trafficClass);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}