/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.mplslabel;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.MplsLabelGeneralUse;
import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.MplsLabelSpecialPurpose;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of mplsLabelUnion.
 */
public final class MplsLabelUnion {
    private MplsLabelSpecialPurpose mplsLabelSpecialPurpose;
    private MplsLabelGeneralUse mplsLabelGeneralUse;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of mplsLabelUnion.
     */
    private MplsLabelUnion() {
    }

    /**
     * Creates an instance of mplsLabelSpecialPurpose.
     *
     * @param mplsLabelSpecialPurpose value of mplsLabelSpecialPurpose
     */
    public MplsLabelUnion(MplsLabelSpecialPurpose mplsLabelSpecialPurpose) {
        setValue.set(0);
        this.mplsLabelSpecialPurpose = mplsLabelSpecialPurpose;
    }

    /**
     * Creates an instance of mplsLabelGeneralUse.
     *
     * @param mplsLabelGeneralUse value of mplsLabelGeneralUse
     */
    public MplsLabelUnion(MplsLabelGeneralUse mplsLabelGeneralUse) {
        setValue.set(1);
        this.mplsLabelGeneralUse = mplsLabelGeneralUse;
    }

    /**
     * Returns the object of mplsLabelUnion for type mplsLabelSpecialPurpose.
     *
     * @param value value of mplsLabelUnion for type mplsLabelSpecialPurpose
     * @return mplsLabelUnion for type mplsLabelSpecialPurpose
     */
    public static MplsLabelUnion of(MplsLabelSpecialPurpose value) {
        return new MplsLabelUnion(value);
    }

    /**
     * Returns the object of mplsLabelUnion for type mplsLabelGeneralUse.
     *
     * @param value value of mplsLabelUnion for type mplsLabelGeneralUse
     * @return mplsLabelUnion for type mplsLabelGeneralUse
     */
    public static MplsLabelUnion of(MplsLabelGeneralUse value) {
        return new MplsLabelUnion(value);
    }

    /**
     * Returns the attribute mplsLabelSpecialPurpose.
     *
     * @return mplsLabelSpecialPurpose value of mplsLabelSpecialPurpose
     */
    public MplsLabelSpecialPurpose mplsLabelSpecialPurpose() {
        return mplsLabelSpecialPurpose;
    }
    /**
     * Returns the attribute mplsLabelGeneralUse.
     *
     * @return mplsLabelGeneralUse value of mplsLabelGeneralUse
     */
    public MplsLabelGeneralUse mplsLabelGeneralUse() {
        return mplsLabelGeneralUse;
    }
    /**
     * Sets the attribute mplsLabelSpecialPurpose.
     *
     * @param mplsLabelSpecialPurpose value of mplsLabelSpecialPurpose
     */
    public void mplsLabelSpecialPurpose(MplsLabelSpecialPurpose mplsLabelSpecialPurpose) {
        this.mplsLabelSpecialPurpose = mplsLabelSpecialPurpose;
    }
    /**
     * Sets the attribute mplsLabelGeneralUse.
     *
     * @param mplsLabelGeneralUse value of mplsLabelGeneralUse
     */
    public void mplsLabelGeneralUse(MplsLabelGeneralUse mplsLabelGeneralUse) {
        this.mplsLabelGeneralUse = mplsLabelGeneralUse;
    }

    @Override
    public int hashCode() {
        return Objects.hash(mplsLabelSpecialPurpose, mplsLabelGeneralUse);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MplsLabelUnion) {
            MplsLabelUnion other = (MplsLabelUnion) obj;
            return
                Objects.deepEquals(mplsLabelSpecialPurpose, other.mplsLabelSpecialPurpose) &&
                Objects.deepEquals(mplsLabelGeneralUse, other.mplsLabelGeneralUse);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return mplsLabelSpecialPurpose.toString();
        }
        if (setValue.get(1)) {
            return mplsLabelGeneralUse.toString();
        }
        return null;
    }
    /**
     * Returns the object of mplsLabelUnion fromString input String mplsLabelUnion.
     *
     * @param valInString value of input String
     * @return mplsLabelUnion
     */
    public static MplsLabelUnion fromString(String valInString) {
        try {
            MplsLabelSpecialPurpose tmpVal = MplsLabelSpecialPurpose.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            MplsLabelGeneralUse tmpVal = MplsLabelGeneralUse.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
