/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.ipv6multicastsourceaddress.ipv6multicastsourceaddressunion;

/**
 * Represents ENUM data of ipv6MulticastSourceAddressUnionEnum1.
 */
public enum Ipv6MulticastSourceAddressUnionEnum1 {

    /**
     * Represents 'any-src-addr'.
     */
    ANY_SRC_ADDR(0, "'any-src-addr'");

    private int ipv6MulticastSourceAddressUnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of ipv6MulticastSourceAddressUnionEnum1.
     *
     * @param ipv6MulticastSourceAddressUnionEnum1 value of ipv6MulticastSourceAddressUnionEnum1
     */
     Ipv6MulticastSourceAddressUnionEnum1(int ipv6MulticastSourceAddressUnionEnum1, String schemaName) {
        this.ipv6MulticastSourceAddressUnionEnum1 = ipv6MulticastSourceAddressUnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of ipv6MulticastSourceAddressUnionEnum1 for.
     *
     * @param value value of ipv6MulticastSourceAddressUnionEnum1 for
     * @return ipv6MulticastSourceAddressUnionEnum1 for
     */
    public static Ipv6MulticastSourceAddressUnionEnum1 of(int value) {
        switch (value) {
            case 0:
                return Ipv6MulticastSourceAddressUnionEnum1.ANY_SRC_ADDR;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of ipv6MulticastSourceAddressUnionEnum1 for.
     *
     * @param value value of ipv6MulticastSourceAddressUnionEnum1 for
     * @return ipv6MulticastSourceAddressUnionEnum1 for
     */
    public static Ipv6MulticastSourceAddressUnionEnum1 of(String value) {
        switch (value) {
            case "'any-src-addr'":
                return Ipv6MulticastSourceAddressUnionEnum1.ANY_SRC_ADDR;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute ipv6MulticastSourceAddressUnionEnum1.
     *
     * @return ipv6MulticastSourceAddressUnionEnum1 value of ipv6MulticastSourceAddressUnionEnum1
     */
    public int ipv6MulticastSourceAddressUnionEnum1() {
        return ipv6MulticastSourceAddressUnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
